<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-13 15:29
 */
interface OfferpricebillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Offerpricebill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param offerpricebill primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Offerpricebill offerpricebill
 	 */
	public function insert($offerpricebill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Offerpricebill offerpricebill
 	 */
	public function update($offerpricebill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOfferpricebillid($value);

	public function queryByProductid($value);

	public function queryByProductname($value);

	public function queryBySellprice($value);

	public function queryByProdescrption($value);

	public function queryByPronumber($value);

	public function queryByTotalprice($value);


	public function deleteByOfferpricebillid($value);

	public function deleteByProductid($value);

	public function deleteByProductname($value);

	public function deleteBySellprice($value);

	public function deleteByProdescrption($value);

	public function deleteByPronumber($value);

	public function deleteByTotalprice($value);


}
?>